/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.network.packet;

import dev.toma.gunsrpg.common.init.ModRegistries;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.network.AbstractNetworkPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class S2C_NewSkillsPacket
extends AbstractNetworkPacket<S2C_NewSkillsPacket> {
    private final List<SkillType<?>> unlocked;

    public S2C_NewSkillsPacket() {
        this(null);
    }

    public S2C_NewSkillsPacket(List<SkillType<?>> list) {
        this.unlocked = list;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.unlocked.size());
        for (SkillType<?> type : this.unlocked) {
            buffer.func_192572_a(type.getRegistryName());
        }
    }

    @Override
    public S2C_NewSkillsPacket decode(PacketBuffer buffer) {
        ArrayList unlocked = new ArrayList();
        int n = buffer.func_150792_a();
        for (int i = 0; i < n; ++i) {
            ResourceLocation location = buffer.func_192575_l();
            SkillType type = (SkillType)ModRegistries.SKILLS.getValue(location);
            if (type == null) continue;
            unlocked.add(type);
        }
        return new S2C_NewSkillsPacket(unlocked);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        this.unlocked.forEach(SkillType::setFresh);
    }
}

